﻿main();

function main(){
	//ダイアログを表示
	myDialog = app.dialogs.add({name:"台紙メーカー"});
	with(myDialog){
		with(dialogColumns.add()){
              with(borderPanels.add()){
					staticTexts.add({staticLabel:"ボックスサイズ横：", minWidth:120});
					var boxW = realEditboxes.add({editValue:91,minimumValue:10,maximumValue:2000, minWidth:80});
                    staticTexts.add({staticLabel:"mm", minWidth:30});
					staticTexts.add({staticLabel:"ボックスサイズ縦：", minWidth:120});
					var boxH = realEditboxes.add({editValue:55,minimumValue:10,maximumValue:2000, minWidth:80});
                    staticTexts.add({staticLabel:"mm", minWidth:30});
			}
			with(borderPanels.add()){
					var Listpercent = new Array( "1","2", "3", "4", "5", "6", "7", "8", "9", "10");
					staticTexts.add({staticLabel:"横個数：", minWidth:120});
					var countW = integerComboboxes.add({editValue:1,minimumValue:1,maximumValue:255,stringList:Listpercent, minWidth:80});
                    staticTexts.add({staticLabel:"個", minWidth:30});
					staticTexts.add({staticLabel:"縦個数：", minWidth:120});
					var countH = integerComboboxes.add({editValue:1,minimumValue:1,maximumValue:255,stringList:Listpercent, minWidth:80});
                    staticTexts.add({staticLabel:"個", minWidth:30});
			}
			with(borderPanels.add()){
					staticTexts.add({staticLabel:"トンボ長：", minWidth:120});
					var tomboL = realEditboxes.add({editValue:10,minimumValue:10,maximumValue:255, minWidth:80});
                    staticTexts.add({staticLabel:"mm", minWidth:30});
					staticTexts.add({staticLabel:"トンボ幅：", minWidth:120});
					var tomboW = realEditboxes.add({editValue:0.2,minimumValue:0.1,maximumValue:2, minWidth:80});
                    staticTexts.add({staticLabel:"pt", minWidth:30});
			}
              with(borderPanels.add()){
					staticTexts.add({staticLabel:"塗り足し：", minWidth:120});
					var nuritashi = realEditboxes.add({editValue:3,minimumValue:0,maximumValue:255, minWidth:80});
                    staticTexts.add({staticLabel:"mm", minWidth:30});
                    staticTexts.add({staticLabel:"センタートンボ：", minWidth:120});
                    var centerT = checkboxControls.add({staticLabel: "必要", minWidth:120, checkedState:true});
			}
		}
	}
	var myReturn = myDialog.show();
	//ここから処理を行う
	if (myReturn == true){
		var boxWvalue = boxW.editValue;
		var boxHvalue = boxH.editValue;
		var countWvalue = countW.editValue;
		var countHvalue = countH.editValue;
        var tomboLvalue = tomboL.editValue;
		var tomboWvalue = tomboW.editValue;
		var nuritashivalue = nuritashi.editValue;
        var centerTvalue = centerT.checkedState;
		myDialog.destroy();
        //ドキュメント作成
		myDocument = indd_make_doc(boxWvalue,boxHvalue,countWvalue,countHvalue,tomboLvalue,tomboWvalue,nuritashivalue);
        //トンボ作成
        indd_make_tombo(myDocument,boxWvalue,boxHvalue,countWvalue,countHvalue,tomboLvalue,tomboWvalue,nuritashivalue);
        // センタートンボ作成
        if (centerTvalue){
            indd_make_center(myDocument,boxWvalue,boxHvalue,countWvalue,countHvalue,tomboLvalue,tomboWvalue,nuritashivalue);
        }
        //ボックスを一つ作成
        indd_make_box(myDocument,boxWvalue,boxHvalue,tomboLvalue,nuritashivalue);
        
        //マスター設定を適応
        myDocument.pages.item(0).appliedMaster = myDocument.masterSpreads.item("A-マスター");
	}
	else{
		myDialog.destroy();
	}
}

function indd_make_doc(boxWvalue,boxHvalue,countWvalue,countHvalue,tomboLvalue,tomboWvalue,nuritashivalue){
    // 新規ドキュメント作成
    var pageW = (boxWvalue*countWvalue+tomboLvalue*2+nuritashivalue*countWvalue*2) + " mm";
    var pageH = (boxHvalue*countHvalue+tomboLvalue*2+nuritashivalue*countHvalue*2) + " mm";
    
    myDocument = app.documents.add();
    //Set up the document.
    with(myDocument.documentPreferences){
        pageHeight = pageH
        pageWidth = pageW
        facingPages = false;
        columnDirection = HorizontalOrVertical.horizontal;
    }
    //Set up the Master Spread.
    myDocument.viewPreferences.rulerOrigin = RulerOrigin.pageOrigin;
    with(myDocument.masterSpreads.item("A-マスター")){
        //マスタースプレッドのページを削除する
        with(pages.item(1)){
            remove();
            }
        }
    return myDocument;
    }

function indd_make_tombo(myDocument,boxWvalue,boxHvalue,countWvalue,countHvalue,tomboLvalue,tomboWvalue,nuritashivalue){
    //トンボの位置を計算
    var tmbL = tomboWvalue;
    var tmbX = tomboLvalue;
    var tmbY = 0;
    var tmbH = tomboLvalue;
    var tmbW = tomboLvalue;
    var plus = tomboLvalue + (boxHvalue + nuritashivalue * 2) * countHvalue;
    // 縦罫作成
    for (i = 0; i < 2; i++) {
        ofx = tmbX + nuritashivalue * i;
        makeLine(myDocument,ofx,tmbY,tmbH,ofx,tmbL);
        makeLine(myDocument,ofx,tmbY+plus,tmbH+plus,ofx,tmbL);
    }
    var w = (boxWvalue + nuritashivalue * 2) * countWvalue; // 図面サイズ
    for (i = 0; i < 2; i++) {
        ofx = tmbX + w - nuritashivalue * i;
        makeLine(myDocument,ofx,tmbY,tmbH,ofx,tmbL);
        makeLine(myDocument,ofx,tmbY+plus,tmbH+plus,ofx,tmbL);
    }
    w = boxWvalue + nuritashivalue * 2;
    if (countWvalue > 0) {
        for (i = 1; i < countWvalue; i++) {
            ofx = tmbX + w * i;
            for (j = -1; j < 2; j++) {
                n = nuritashivalue * j;
                makeLine(myDocument,ofx+n,tmbY,tmbH,ofx+n,tmbL);
                makeLine(myDocument,ofx+n,tmbY+plus,tmbH+plus,ofx+n,tmbL);
            }
        }
    }
    
    // 横罫作成
    tmbL = tomboWvalue;
    tmbX = 0;
    tmbY = tomboLvalue;
    tmbH = tomboLvalue;
    tmbW = tomboLvalue;
    plus = tomboLvalue + (boxWvalue + nuritashivalue * 2) * countWvalue;
    for (i = 0; i < 2; i++) {
        ofy = tmbY + nuritashivalue * i;
        makeLine(myDocument,tmbX,ofy,ofy,tmbW,tmbL);
        makeLine(myDocument,tmbX+plus,ofy,ofy,tmbW+plus,tmbL);
    }
    w = (boxHvalue + nuritashivalue * 2) * countHvalue; // 図面サイズ
    for (i = 0; i < 2; i++) {
        ofy = tmbY + w - nuritashivalue * i;
        makeLine(myDocument,tmbX,ofy,ofy,tmbW,tmbL);
        makeLine(myDocument,tmbX+plus,ofy,ofy,tmbW+plus,tmbL);
    }
    w = boxHvalue + nuritashivalue * 2;
    if (countHvalue > 0) {
        for (i = 1; i < countHvalue; i++) {
            ofy = tmbY + w * i;
            for (j = -1; j < 2; j++) {
                n = nuritashivalue * j;
                makeLine(myDocument,tmbX,ofy+n,ofy+n,tmbW,tmbL);
                makeLine(myDocument,tmbX+plus,ofy+n,ofy+n,tmbW+plus,tmbL);
            }
        }
    }
    
}

function indd_make_center(myDocument,boxWvalue,boxHvalue,countWvalue,countHvalue,tomboLvalue,tomboWvalue,nuritashivalue){
    // センタートンボを作成
    // ドキュメントサイズ
    var pageW = (boxWvalue*countWvalue+tomboLvalue*2+nuritashivalue*countWvalue*2);
    var pageH = (boxHvalue*countHvalue+tomboLvalue*2+nuritashivalue*countHvalue*2);
    
    // センター縦罫
    if (countWvalue % 2 !== 0) {
        var tmbL = tomboWvalue;
        var tmbX = pageW / 2;
        var tmbY = 0;
        var tmbH = tomboLvalue;
        var tmbW = tmbX;
        var plus = tomboLvalue + (boxHvalue + nuritashivalue * 2) * countHvalue;

        makeLine(myDocument,tmbX,tmbY,tmbH,tmbW,tmbL);
        makeLine(myDocument,tmbX,tmbY+plus,tmbH+plus,tmbW,tmbL);
    }
    // センター横罫
    if (countHvalue % 2 !== 0) {
        var tmbL = tomboWvalue;
        var tmbX = 0;
        var tmbY = pageH / 2;
        var tmbH = tmbY;
        var tmbW = tomboLvalue;
        var plus = tomboLvalue + (boxWvalue + nuritashivalue * 2) * countWvalue;

        makeLine(myDocument,tmbX,tmbY,tmbH,tmbW,tmbL);
        makeLine(myDocument,tmbX+plus,tmbY,tmbH,tmbW+plus,tmbL);
    }
    
    // センター縦罫の横棒
        var tmbL = tomboWvalue;
        var tmbX = pageW / 2 - 10;
        var tmbY = tomboLvalue - 3;
        var tmbH = tmbY;
        var tmbW = pageW / 2 + 10;
        var plus = tomboLvalue + (boxHvalue + nuritashivalue * 2) * countHvalue + 3;

        makeLine(myDocument,tmbX,tmbY,tmbH,tmbW,tmbL);
        makeLine(myDocument,tmbX,plus,plus,tmbW,tmbL);
    
    //　センター横罫の縦棒
        var tmbL = tomboWvalue;
        var tmbX = tomboLvalue - 3;
        var tmbY = pageH / 2 - 10;
        var tmbH = pageH / 2 + 10;
        var tmbW = tmbX;
        var plus = tomboLvalue + (boxWvalue + nuritashivalue * 2) * countWvalue + 3;

        makeLine(myDocument,tmbX,tmbY,tmbH,tmbW,tmbL);
        makeLine(myDocument,plus,tmbY,tmbH,plus,tmbL);
}

function makeLine(myDocument,tmbX,tmbY,tmbH,tmbW,tmbL){
    //マスターページに線を引く
    myDocument.viewPreferences.rulerOrigin = RulerOrigin.pageOrigin;
    var X = tmbX + " mm";
    var Y = tmbY + " mm";
    var H = tmbH + " mm";
    var W = tmbW + " mm";
    var L = tmbL + " pt";
    
    with(myDocument.masterSpreads.item("A-マスター")){
        pObj = rectangles.add();
        pObj.strokeWeight = L;
        pObj.strokeColor = "Registration";
        pObj.paths.item(0).entirePath = [[X,Y],[W,H]];
    }
}

function indd_make_box(myDocument,boxW,boxH,tomboL,nuritashi){
    //ボックスを作成
    myDocument.viewPreferences.rulerOrigin = RulerOrigin.pageOrigin;
    var X = tomboL + " mm";
    var Y = tomboL + " mm";
    var H = (boxH + nuritashi*2 + tomboL) + " mm";
    var W = (boxW + nuritashi*2 + tomboL) + " mm";
    with(myDocument.masterSpreads.item("A-マスター")){
        pObj = textFrames.add();
        pObj.visibleBounds = [Y,X,H,W];
    }

}
